define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.service('CustomMessagesService', function ($http, $q, localResourceDirectoryService) {

		var CustomMessagesService = {};
		var fetchOptions = {};
		var customServicesUrl = localResourceDirectoryService['var-custom-messages'];
		var customMessageDefaultUrl = localResourceDirectoryService['var-custom-messages-default'];

		CustomMessagesService.getFacility = function() {
			return mhpuser.facilityName;
		}

		CustomMessagesService.fetch = function(locationId) {
			return $http.get(customServicesUrl.replace('{site-code}', locationId));
		};

		CustomMessagesService.fetchDefault = function(messageId) {
			fetchOptions = {
				url: customMessageDefaultUrl.replace('{message-id}', messageId),
				method: 'get'
			};
			return $http[fetchOptions.method](fetchOptions.url);
		};

        CustomMessagesService.save = function(data,locationId) {
            //for this service we are only using the put option
            return $http.put(customServicesUrl.replace('{site-code}', locationId), data);
        };
        return CustomMessagesService;

	});
});
